/*
 *
 *	This is free software. You can redistribute it and/or modify under
 *	the terms of the GNU General Public License version 2.
 *
 * 	Copyright (C) 1998 by kra
 *
 */
#include "hunt.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define LINES_O_UNLIMITED	1000000
int lines_o = LINES_O_UNLIMITED;

static void list_conn_properties(void)
{
	int c;
	int mac, seq;
	
	c = menu_choose_char("print MAC y/n", "ny", conn_list_mac ? 'y' : 'n');
	switch (c) {
	    case 'n':
		mac = 0;
		break;
	    case 'y':
		mac = 1;
		break;
	    default:
		return;
	}
	c = menu_choose_char("print SEQ y/n", "ny", conn_list_seq ? 'y' : 'n');
	switch (c) {
	    case 'n':
		seq = 0;
		break;
	    case 'y':
		seq = 1;
		break;
	    default:
		return;
	}
	conn_list_mac = mac;
	conn_list_seq = seq;	
}

static void print_host_properties(void)
{
	switch (menu_choose_char("Resolve host names", "yn", 
				 hl_mode == HL_MODE_NR ? 'n' : 'y')) {
	    case 'y':
		hl_mode = HL_MODE_DEFERRED;
		break;
	    case 'n':
		hl_mode = HL_MODE_NR;
		break;
	    default:
		break;
	}
}

static void mac_learn_from_ip_opt(void)
{
	switch (menu_choose_char("Learn MAC from IP traffic", "yn", 
				 mac_learn_from_ip == 0 ? 'n' : 'y')) {
	    case 'y':
		mac_learn_from_ip = 1;
		break;
	    case 'n':
		mac_learn_from_ip = 0;
		break;
	    default:
		break;
	}
}

static void ackstorm_reset_sec(void)
{
	int sec;
	
	if ((sec = menu_choose_unr("ACK storm reset sec", 0, 10000, storm_reset_sec)) < 0)
		return;
	storm_reset_sec = sec;
}

static void storm_hijack_wait_sec(void)
{
	int sec;
	
	if ((sec = menu_choose_unr("Sec to wait for next cmd with simple hijack", 0, 10000, storm_reset_sec)) < 0)
		return;
	stormack_hijack_wait_sec = sec;
}

static void printed_lines_per_page(void)
{
	int n;
	
	n = lines_o;
	if (n == LINES_O_UNLIMITED)
		n = 0;
	if ((n = menu_choose_unr("Number of printed lines per page in listeinings", 0, 10000, n)) < 0)
		return;
	if (n == 0)
		lines_o = LINES_O_UNLIMITED;
	else
		lines_o = n;
}

void lines_o_press_key(void)
{
	press_key("press key");	
}

void options_menu(void)
{
	char *o_menu =  "l) list add conn policy\n"
			"a/m/d) add/mod/del conn policy entry\n"
			"c) connection listing properties\n"
			"h) host resolving\n"
			"r) reset ACK storm timeout\n"
			"s) simple hijack timeout for next cmd\n"
			"e) learn MAC from IP traffic\n"
			"p) numer of printed lines per page in listeingings\n"
			"x) return\n";
	char *o_keys = "lamdchrsepx";
	int run_it;
	
	run_it = 1;
	while (run_it) {
		switch (menu("options", o_menu, "opt", o_keys, 0)) {
		    case 'l':
			addpolicy_list_items();
			break;
		    case 'a':
			addpolicy_add_item();
			break;
		    case 'd':
			addpolicy_del_item();
			break;
		    case 'm':
			addpolicy_mod_item();
			break;
		    case 'c':
			list_conn_properties();
			break;
		    case 'h':
			print_host_properties();
			break;
		    case 'r':
			ackstorm_reset_sec();
			break;
		    case 's':
			storm_hijack_wait_sec();
			break;
		    case 'e':
			mac_learn_from_ip_opt();
			break;
		    case 'p':
			printed_lines_per_page();
			break;
		    case 'x':
			run_it = 0;
			break;
		}
	}
}

